PSCAD 4.2.0

Settings
 {
 Id = "901548811.1144362701"
 Author = "gdi.jayas"
 Desc = "12-Pulse Simple Inverter"
 Arch = "windows"
 Options = 8
 Build = 20
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "Untitled.out"
  SFile = "Untitled.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 50.0 [Hz]
  }

 }

Definitions
 {
 Component("Matlab_spectral")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Text("Name",6,2,248,12,2)
     {
     Desc = "Matlab Module Name"
     Def = "spectral"
     Len = 30
     }
    Text("Path",6,16,248,12,2)
     {
     Desc = "Relative path of .m Files"
     Def = "mfiles"
     Len = 30
     }
    Input("Enabl",6,32,248,12,6)
     {
     Desc = "Enable=1 , Disable=0"
     Def = "1"
     Data = Real
     Len = 15
     Min = 0
     Max = 1
     }
    Input("PNUM",6,46,248,12,2)
     {
     Desc = "Plot Number"
     Def = "1"
     Data = Real
     Len = 3
     Min = 1
     Max = 10
     }
    Input("SCALE",6,60,248,12,6)
     {
     Desc = "Scale for Vertical Axis"
     Def = "100.0"
     Data = Real
     Len = 15
     Min = 0
     }
    }
   }

  Nodes = 
   {
   Input("INPUT",-72,0)
    {
    Type = Real
    Dim  = [31]
    }
   Output("OUTPUT",72,0)
    {
    Type = Real
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Rectangle(-45,-15,45,15)
   Line(-72,0,-45,0)
   Text(-58,16,"inp")
   Line(-50,-5,-45,0)
   Line(-45,0,-50,5)
   Line(72,0,45,0)
   Line(-55,-3,-61,3)
   Text(-58,-1,"31")
   Line(61,-3,55,3)
   Text(58,-1,"2")
   Text(0,6,"%Name")
   Text(-3,28,"New Matlab Interface")
   }

  Section(EMTDC)
   {
   Dsdyn = "\
#STORAGE REAL:34 INTEGER:1
! --------------------------------------------------
! --------------------------------------------------
! PSCAD/EMTDC - MATLAB INTERFACE
! Module: $Name
#LOCAL INTEGER I_CNT
      IF($Enabl.GT.0.9) THEN
! --------------------------------------------------
! Transfer EMTDC Input Variables to Matlab Interface
! --------------------------------------------------
!
! First Input Array (REAL(31))
       DO I_CNT=1,31,1
          STORF(NSTORF+I_CNT-1) = $INPUT(I_CNT)
       END DO
! Second Input Variable (INTEGER)
       STORI(NSTORI) = $PNUM   
! Third Input Variable (REAL)
       STORF(NSTORF+31) = $SCALE
!
! --------------------------------------------------
! Call PSCAD/EMTDC Matlab Interface:
! CALL MLAB_INT(\"MFILEPATH\",\"MFILENAME\",\"Input Format\",\"Output Format\")
! --------------------------------------------------
       CALL MLAB_INT(\"%:Dir\\$Path\", \"$Name\", \"R(31) I R\" , \"R(2)\" )
!
! --------------------------------------------------
! Transfer Matlab Output Variables from Matlab Interface
! --------------------------------------------------
!
! First Output Array (REAL(2))
       DO I_CNT=1,2,1
          $OUTPUT(I_CNT) = STORF(NSTORF+31+I_CNT)
       END DO
      ENDIF
! Update STORx Pointers
      NSTORF = NSTORF + 34
      NSTORI = NSTORI + 1
! --------------------------------------------------
! --------------------------------------------------"
   Help = "..\\pscad\\matlab\\index.htm"
   }
  }
 Component("holder")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   }

  Nodes = 
   {
   Output("OUT",36,0)
    {
    Type = Real
    }
   Input("IN1",-36,0)
    {
    Type = Real
    }
   Input("IN2",0,36)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Rectangle(-13,-13,13,13)
   Line(-36,0,-13,0)
   Line(13,0,36,0)
   Line(-19,-5,-13,0)
   Line(-13,0,-19,5)
   Line(-5,19,0,13)
   Line(0,13,5,19)
   Line(0,13,0,36)
   Text(0,6,"H")
   }

  Section(EMTDC)
   {
   Fortran = "\
#STORAGE REAL:1
! Hold
      IF($IN2.GE.1) THEN
        STORF(NSTORF) = $IN1
      ENDIF
      $OUT =STORF(NSTORF)
      NSTORF = NSTORF+1
!
"
   }
  }
 Component("seqtra")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Choice("Rampe",6,2,180,12,3)
     {
     Style = 0
     Desc = "external w*t ramp ?"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    }
   Category("Sequence Data")
    {
    Input("VPm",6,2,180,12,7)
     {
     Desc = "Magnitude of +ve seq."
     Def = "1.0"
     Data = Real
     Unit = "pu"
     Len = 15
     Min = 0
     }
    Input("VPp",6,16,180,12,7)
     {
     Desc = "Phase of +ve seq."
     Def = "0"
     Data = Real
     Unit = "deg"
     Len = 15
     Min = -180
     Max = 180
     }
    Input("VMm",6,30,180,12,7)
     {
     Desc = "Magnitude of -ve seq."
     Def = "0.0"
     Data = Real
     Unit = "pu"
     Len = 15
     Min = 0
     }
    Input("VMp",6,44,180,12,7)
     {
     Desc = "Phase of -ve. seq"
     Def = "0.0"
     Data = Real
     Unit = "deg"
     Len = 15
     Min = -180
     Max = 180
     }
    Input("VOm",6,58,180,12,7)
     {
     Desc = "Magnitude of Zero seq."
     Def = "0.0"
     Data = Real
     Unit = "pu"
     Len = 15
     Min = 0
     }
    Input("VOp",6,72,180,12,7)
     {
     Desc = "phase of Zero  seq"
     Def = "0.0"
     Data = Real
     Unit = "deg"
     Len = 15
     Min = -180
     Max = 180
     }
    Input("Vbase",6,86,180,12,7)
     {
     Desc = "Voltage Base (l-l, rms)"
     Def = "230.0"
     Data = Real
     Unit = "kV"
     Len = 15
     Min = 0
     }
    }
   Category("frequency and phase")
    {
    Cond = "(Rampe==0)"
    Input("Freq",6,2,180,12,7)
     {
     Desc = "Frequency of source"
     Def = "60.0"
     Data = Real
     Unit = "Hz"
     Len = 15
     Min = 0
     }
    Choice("sincos",6,16,180,12,3)
     {
     Style = 0
     Desc = "sin or cos waveform"
     Def = "0"
     Len = 15
     *0 = "sin"
     *1 = "cos"
     }
    Input("phas",6,30,180,12,7)
     {
     Desc = "additional phase shift"
     Def = "0.0"
     Data = Real
     Unit = "deg"
     Len = 15
     Min = -180
     Max = 180
     }
    }
   Category("Internal Output Variables")
    {
    Cond = "(EMTDC)"
    Text("VAm",6,2,180,12,3)
     {
     Desc = "Name for   A mag"
     Len = 11
     }
    Text("VAp",6,16,180,12,3)
     {
     Desc = "Name for   A phase"
     Len = 11
     }
    Text("VBm",6,30,180,12,3)
     {
     Desc = "Name for   B mag"
     Len = 11
     }
    Text("VBp",6,44,180,12,3)
     {
     Desc = "Name for   B phase"
     Len = 11
     }
    Text("VCm",6,58,180,12,3)
     {
     Desc = "Name for   C mag"
     Len = 11
     }
    Text("VCp",6,72,180,12,3)
     {
     Desc = "Name for   C phase"
     Len = 11
     }
    }
   }

  Nodes = 
   {
   Output("VAT",36,-36)
    {
    Type = Real
    }
   Output("VBT",36,0)
    {
    Type = Real
    }
   Output("VCT",36,36)
    {
    Type = Real
    }
   Input("Thetaa",-36,0)
    {
    Cond = "Rampe==1"
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-27,-45,9,45)
   Line(36,-36,9,-36)
   Line(36,0,9,0)
   Line(36,36,9,36)
   Cond = "(Rampe==1)"
   Line(-36,0,-27,0)
   Cond = "true"
   Text(27,-34,"Va")
   Text(27,1,"Vb")
   Text(27,37,"Vc")
   Cond = "(Rampe==1)"
   Text(-40,15,"theta")
   Cond = "true"
   Text(-9,6,"seqtra")
   }

  Section(EMTDC)
   {
   Computations = "\
REAL twopi= 2*PI
REAL Ofset= (Rampe == 0 && sincos == 0) ? -90 : 0
"
   Dsdyn = "\
#STORAGE REAL:1
!  seqtra
#LOCAL REAL RVD1_7
#IF Rampe==1
         RVD1_7 = $Thetaa
#ELSE
      STORF(NSTORF) = STORF(NSTORF) + 360.0*$Freq*DELT
       IF(STORF(NSTORF).GE.360.0)STORF(NSTORF)=STORF(NSTORF)-360.0
       RVD1_7 = STORF(NSTORF) + ($phas) + ($Ofset)
      NSTORF=NSTORF+1
#END
#LOCAL REAL RVD1_1
#LOCAL REAL RVD1_2
#LOCAL REAL RVD1_3
#LOCAL REAL RVD1_4
#LOCAL REAL RVD1_5
#LOCAL REAL RVD1_6
      CALL SEQTRA($VPm*$Vbase,$VMm*$Vbase,$VOm*$Vbase,$VPp,$VMp,$VOp,
     .      RVD1_7,RVD1_1,RVD1_3,RVD1_5,RVD1_2,RVD1_4,RVD1_6,$VAT,$VBT,$VCT)
!
#OUTPUT REAL VAm {RVD1_1}
#OUTPUT REAL VAp {RVD1_2}
#OUTPUT REAL VBm {RVD1_3}
#OUTPUT REAL VBp {RVD1_4}
#OUTPUT REAL VCm {RVD1_5}
#OUTPUT REAL VCp {RVD1_6}
"
   Files = "\
seqtra.f
"
   }
  }
 Module("MULTIPLOT")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Text(0,4,"MULTIPLOT")
   }


  Page(A/A4,Landscape,48,[597,467],100)
   {
   -Plot-([36,90],0)
    {
    Title = "Untitled"
    Draw = 1
    Area = [0,0,666,1098]
    Posn = [-1,-1]
    Icon = [-1,-1]
    Extents = 0,0,666,1098
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,666,1035],"")
     {
     Options = 0
     Units = ""
     Curve(25309056,"Ia_y current ",0,,,)
     Curve(25311704,"Ia_d current",1,,,)
     Curve(46215208,"Idc",2,,,)
     }
    }
   }
  }
 Module("pulsebridge")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Electrical("ComBus",-54,-108)
    {
    }
   Electrical("A1",-54,-72)
    {
    }
   Electrical("B1",-54,-36)
    {
    }
   Electrical("C1",-54,0)
    {
    }
   Electrical("A2",-54,108)
    {
    }
   Electrical("B2",-54,144)
    {
    }
   Electrical("C2",-54,180)
    {
    }
   Electrical("out",54,-108)
    {
    }
   }

  Graphics = 
   {
   Rectangle(-39,-129,39,198)
   Pen(ByNode,ByNode,ByNode,ComBus)
   Line(-54,-108,-39,-108)
   Pen(,,,A1)
   Line(-54,-72,-39,-72)
   Pen(,,,B1)
   Line(-54,-36,-39,-36)
   Pen(,,,C1)
   Line(-54,0,-39,0)
   Pen(,,,A2)
   Line(-54,108,-39,108)
   Pen(,,,B2)
   Line(-54,144,-39,144)
   Pen(,,,C2)
   Line(-54,180,-39,180)
   Pen(,,,ComBus)
   Line(39,-108,54,-108)
   Text(-54,-97,"CBus")
   Text(-46,-60,"A")
   Text(-46,-24,"B")
   Text(-46,12,"C")
   Text(-46,121,"A")
   Text(-46,156,"B")
   Text(-46,192,"C")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   }
  }
 Module("graph")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-29,-38,31,39)
   Line(-15,-5,-15,35)
   Line(-20,30,20,30)
   Line(-15,29,-8,3)
   Line(-1,22,-8,3)
   Line(-1,21,5,0)
   Line(5,0,15,23)
   Line(15,22,18,11)
   Text(2,-22,"Graph")
   Text(2,-9,"Page")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "EXAMPLE CASE: FOURIER ANALYSIS CALCULATION USING MATLAB - GRAPH SUBPAGE"
    }
   -Plot-([72,72],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,1062,540]
    Posn = [72,72]
    Icon = [-18,270]
    Extents = 0,0,1062,540
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1062,477],"kA")
     {
     Options = 0
     Units = ""
     Curve(25309056,"Ia_y current ",0,,,)
     Curve(25311704,"Ia_d current",1,,,)
     Curve(46215208,"Idc",2,,,)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = " MAIN"
  FileDate = 1144362510
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,56,[597,467],100)
   {
   0.ground([522,522],1,0,-1)
    {
    }
   0.ground([522,774],1,0,-1)
    {
    }
   0.resistor([540,810],7,0,-1)
    {
    R = "1.0E6 [ohm]"
    }
   0.ground([540,846],1,0,-1)
    {
    }
   -Wire-([468,738],0,0,-1)
    {
    Vertex="0,0;0,-252"
    }
   -Wire-([468,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([450,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([252,612],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([990,378],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.nodelabel([1008,378],2,0,-1)
    {
    Name = "DCRC"
    MeasV = "0"
    PU = "0"
    VName = "VNode"
    VBase = "1.0 [kV]"
    }
   0.pgb([1044,270],0,25247968,680)
    {
    Name = "AC Bus Volts"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "500.0"
    }
   0.inductor([1116,450],3,0,-1)
    {
    L = ".15 [H]"
    }
   0.sumjct([1062,1242],0,0,400)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([1026,1242],1,0,-1)
    {
    Name = "Vdc6py"
    }
   0.datalabel([1062,1278],0,0,-1)
    {
    Name = "Vneut"
    }
   0.pgb([1098,1242],0,25256616,410)
    {
    Name = "Vp"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.sumjct([1062,1152],0,0,340)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([1062,1188],0,0,-1)
    {
    Name = "Vneut"
    }
   0.pgb([1098,1152],0,25258624,350)
    {
    Name = "Vn"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.const([990,1152],0,0,320)
    {
    Name = ""
    Value = "0.0"
    }
   0.source1([1116,648],7,0,-1)
    {
    Name = "dcsourc"
    Type = "1"
    Ctrl = "0"
    Vm = "500.0 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.005 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "491 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = ""
    }
   0.ground([1116,684],1,0,-1)
    {
    }
   0.xfmr-3p2w([540,738],0,0,160)
    {
    Name = "YYinv"
    Tmva = "530 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.15 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230.0 [kV]"
    V2 = "208 [kV]"
    Enab = "0"
    Sat = "2"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = "Iay"
    ILB1 = "Iby"
    ILC1 = "Icy"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = "IvaY"
    ILB2 = "IvbY"
    ILC2 = "IvcY"
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.xfmr-3p2w([540,486],0,0,100)
    {
    Name = "YDinv"
    Tmva = "530 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "1"
    Lead = "1"
    Xl = ".15 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230 [kV]"
    V2 = "208 [kV]"
    Enab = "0"
    Sat = "2"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = "Iad"
    ILB1 = "Ibd"
    ILC1 = "Icd"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = "IvaD"
    ILB2 = "IvbD"
    ILC2 = "IvcD"
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   -Wire-([468,738],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,612],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.ground([90,738],1,0,-1)
    {
    }
   0.ground([162,738],1,0,-1)
    {
    }
   0.ground([234,738],1,0,-1)
    {
    }
   -Wire-([90,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.source1([90,702],7,0,620)
    {
    Name = "xa"
    Type = "1"
    Ctrl = "2"
    Vm = "132.79056 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "100.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = ".01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "Ia"
    }
   0.source1([162,702],7,0,610)
    {
    Name = "xb"
    Type = "1"
    Ctrl = "2"
    Vm = "132.79056 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "100.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "Ib"
    }
   0.source1([234,702],7,0,600)
    {
    Name = "xc"
    Type = "1"
    Ctrl = "2"
    Vm = "132.79056 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "100.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "Ic"
    }
   -Wire-([54,738],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([198,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([126,792],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([198,792],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([198,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.resistor([450,612],2,0,-1)
    {
    R = ".01 [ohm]"
    }
   -Wire-([324,630],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.nodeloop([288,612],0,0,110)
    {
    View = "1"
    }
   -Wire-([288,576],0,0,-1)
    {
    Vertex="0,0;0,-198;324,-198;324,-180"
    }
   -Wire-([324,684],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.capacitor([324,684],1,0,-1)
    {
    C = "43.11 [uF]"
    }
   0.inductor([324,738],1,0,-1)
    {
    L = ".001003 [H]"
    }
   0.resistor([360,810],1,0,-1)
    {
    R = "11.11 [ohm]"
    }
   0.inductor([324,810],1,0,-1)
    {
    L = "0.0003944 [H]"
    }
   0.capacitor([288,810],1,0,-1)
    {
    C = "67.05 [uF]"
    }
   -Wire-([288,792],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([288,864],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.ground([324,864],1,0,-1)
    {
    }
   0.ammeter([324,630],1,0,130)
    {
    Name = "IFilter"
    }
   0.resistor([198,612],2,0,-1)
    {
    R = "1.95 [ohm]"
    }
   0.inductor([252,612],2,0,-1)
    {
    L = "0.02471 [H]"
    }
   0.fft([1062,1026],0,0,520)
    {
    Type = "4"
    Size = "2"
    F = "$(freq)"
    AMod = "0"
    PMod = "1"
    PModCS = "0"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = "\""
    }
   0.datalabel([1062,954],2,0,-1)
    {
    Name = "Ineg"
    }
   0.datalabel([1026,954],2,0,-1)
    {
    Name = "Ipos"
    }
   0.annotation([1062,918],0,0,-1)
    {
    AL1 = "ON-LINE FFT"
    AL2 = ""
    }
   0.impulse([198,1458],0,0,420)
    {
    F = "100 [Hz]"
    Start = "0.01 [s]"
    Mag = "1"
    Cnfg = "0"
    INTR = "0"
    }
   0.select([270,1494],0,0,510)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([306,1494],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([324,1494],0,0,-1)
    {
    Name = "clk"
    }
   0.var_switch([342,1530],4,24001920,440)
    {
    Name = "MAT-ENAB"
    Group = "Matlab"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.consti([198,1494],0,0,430)
    {
    Name = ""
    Value = "0"
    }
   0.annotation([324,900],0,0,-1)
    {
    AL1 = "DT 12/24 - F2"
    AL2 = "720 MVAR FILTER"
    }
   0.pgb([828,1260],0,23083792,390)
    {
    Name = "Vdc_6pD"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([720,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.realpole([792,1224],0,0,370)
    {
    Limit = "0"
    COM = ""
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.016 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.pgb([828,1224],0,24104232,380)
    {
    Name = "Vdc_6pD filtered"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.sumjct([684,1224],6,0,360)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([648,1224],5,0,-1)
    {
    Name = "Vdc12p"
    }
   0.datalabel([684,1188],6,0,-1)
    {
    Name = "Vdc6pY"
    }
   -Wire-([738,1260],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([738,1134],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([828,1170],0,46068992,330)
    {
    Name = "Vdc_6pY"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.realpole([792,1134],0,0,300)
    {
    Limit = "0"
    COM = ""
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.016 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([702,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1170],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.pgb([828,1134],0,23759000,310)
    {
    Name = "Vdc_6pY filtered"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([702,1134],4,0,-1)
    {
    Name = "Vdc6pY"
    }
   0.datalabel([702,1044],0,0,-1)
    {
    Name = "Vdc12p"
    }
   -Wire-([702,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.realpole([792,1044],0,0,250)
    {
    Limit = "0"
    COM = ""
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.016 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   -Wire-([738,1080],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.pgb([828,1044],0,23983888,270)
    {
    Name = "Vdc_12p filtered"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "600.0"
    }
   -Wire-([738,1080],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.pgb([828,1080],0,23984288,290)
    {
    Name = "Vdc_12p"
    Group = "DC Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-600.0"
    Max = "600.0"
    }
   0.datalabel([702,954],0,0,-1)
    {
    Name = "Idc"
    }
   -Wire-([702,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([828,990],0,46215208,230)
    {
    Name = "Idc"
    Group = "DC Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3"
    Max = "3"
    }
   -Wire-([738,954],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.realpole([792,954],0,0,210)
    {
    Limit = "0"
    COM = ""
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.016 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.pgb([828,954],0,46216280,220)
    {
    Name = "Idc filtered"
    Group = "DC Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   -SrcFile-([90,882],0)
    {
   Name = "seqtra.f"
    }
   .Matlab_spectral([144,1008],0,0,540)
    {
    Name = "spectral1"
    Path = "mfiles"
    Enabl = "clk"
    PNUM = "1"
    SCALE = "SCALE1"
    }
   0.datalabel([72,1008],1,0,-1)
    {
    Name = "Ipos"
    }
   -Wire-([216,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   .seqtra([126,828],3,0,180)
    {
    Rampe = "0"
    VPm = "VplusM"
    VPp = "VplusP"
    VMm = "VminM"
    VMp = "VminP"
    VOm = "VzeroM"
    VOp = "VzeroP"
    Vbase = "Vbase"
    Freq = "$(freq)"
    sincos = "0"
    phas = "0.0 [deg]"
    VAm = "Vamm"
    VAp = "Vapp"
    VBm = ""
    VBp = ""
    VCm = ""
    VCp = ""
    }
   -Sticky-([198,1350],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,1350,450,1422
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Variable 'CLK' which controls if a MATLAB function is called at present time step
  - value of '0' - MATLAB function is not called
  - value of '1' - MATLAB functiun is called"
    }
   -Sticky-([468,234],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 468,234,576,270
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "On-line Control of a plot scale."
    }
   -Wire-([738,990],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([738,1260],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -ControlPanel-([1008,738],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1008,738
    Extents = 0,0,72,126
    Slider(23036416)
    }
   .Matlab_spectral([360,1008],0,0,530)
    {
    Name = "spectral1"
    Path = "mfiles"
    Enabl = "clk"
    PNUM = "2"
    SCALE = "SCALE1"
    }
   0.datalabel([288,1008],1,0,-1)
    {
    Name = "Ineg"
    }
   -Wire-([432,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([54,1080],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,1080,234,1314
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A component SPECTRAL

It provides the interface to a MATLAB function 'spectral1', which is defined  in the m-file 'spectral1.m. This component plots values in bar representation.

Input: Y values, total of 31, to be plot

Output: a dummy output of value zero


"
    }
   -Sticky-([252,1080],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,1080,576,1314
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Parameters of SPECTRAL component. 

- Matlab Module Name
      - name of the .m file
- Path of .m files   
      - it defines the path to a directory, which contains m-file
        used by the component 
- Enable=1, Disable=0
      - it controls if, and how often, a MATLAB function is called:
          0 - function is not called in present time step
          1 - function is called in present time step
- Plot Number           
      - it defines the number of a plot 
- Scale for Vertical Axis
      - it sets the range for Y axis
"
    }
   -Sticky-([54,1350],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,1350,180,1422
    Alignment = 1
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "Impulse generator. Its frequency controls how often a MATLAB function is called."
    }
   -Sticky-([1026,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1026,90,1170,126
    Alignment = 1
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
This is a MATLAB m-file. Double click to see it.
"
    }
   -Sticky-([54,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,72,450,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
WARNING

* This case only works if you use the Digital/Compaq/Intel F90 Fortran Compiler.
* This case will not run on the Student Edition of PSCAD because it has more than 15 nodes!  Contact support@pscad.com for information on other editions.  "
    }
   -SrcFile-([918,90],0)
    {
   Name = "mfiles\\spectral1.m"
    }
   -Wire-([90,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([540,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "EXAMPLE CASE: FOURIER ANALYSIS CALCULATION USING MATLAB"
    }
   -Wire-([1116,378],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([1116,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.resistor([1008,522],2,0,-1)
    {
    R = "1000 [ohm]"
    }
   0.inductor([1008,486],2,0,-1)
    {
    L = ".01671 [H]"
    }
   0.capacitor([1008,450],2,0,-1)
    {
    C = "2.84 [uF]"
    }
   0.capacitor([1116,486],2,0,-1)
    {
    C = "1.0 [uF]"
    }
   0.inductor([1080,486],2,0,-1)
    {
    L = ".01919 [H]"
    }
   -Wire-([1026,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([954,522],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.ground([954,486],2,0,-1)
    {
    }
   0.inductor([1116,558],3,0,-1)
    {
    L = ".15 [H]"
    }
   -Wire-([1116,576],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.resistor([1116,612],3,0,-1)
    {
    R = "1.0 [ohm]"
    }
   -ControlPanel-([486,72],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 486,72
    Extents = 0,0,72,126
    Slider(23037216)
    }
   0.datalabel([1098,270],0,0,-1)
    {
    Name = "IvaD"
    }
   -Wire-([1098,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1134,270],0,44715096,670)
    {
    Name = "Iva_d curren"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1098,198],0,0,-1)
    {
    Name = "Iay"
    }
   0.pgb([1134,198],0,25309056,710)
    {
    Name = "Ia_y current "
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3"
    Max = "3"
    }
   -Wire-([1098,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1098,234],0,0,-1)
    {
    Name = "Iad"
    }
   0.pgb([1134,234],0,25311704,690)
    {
    Name = "Ia_d current"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3"
    Max = "3"
    }
   -Wire-([1098,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1008,198],0,0,-1)
    {
    Name = "IvaY"
    }
   0.pgb([1044,198],0,25315272,720)
    {
    Name = "IvaY current"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1008,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breakout([162,630],7,0,-1)
    {
    Dis = "0"
    }
   -Wire-([198,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,738],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([324,792],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([360,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([360,864],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([324,864],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([288,864],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([288,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([324,792],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([630,648],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.ground([630,828],1,0,-1)
    {
    }
   -Wire-([684,540],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([720,774],0,0,-1)
    {
    Vertex="0,0;0,-252"
    }
   -Wire-([684,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,792],0,0,-1)
    {
    Vertex="0,0;0,-252"
    }
   0.datalabel([738,702],0,0,-1)
    {
    Name = "GRS"
    }
   0.datalabel([702,450],0,0,-1)
    {
    Name = "GRD"
    }
   0.datalabel([702,792],0,0,-1)
    {
    Name = "KBI"
    }
   0.g6p200([630,486],0,0,640)
    {
    UP = "0"
    FP = "0"
    SNUB = "0"
    KV = "-2"
    View = "1"
    FR = "$(freq)"
    GP = "10"
    GI = "50"
    KP = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = "VvD"
    VCurr = ""
    SCurr = ""
    }
   0.g6p200([630,738],0,0,570)
    {
    UP = "0"
    FP = "0"
    SNUB = "0"
    KV = "-1"
    View = "1"
    FR = "$(freq)"
    GP = "10"
    GI = "50"
    KP = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E8 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = "VvY"
    VCurr = "IvY"
    SCurr = ""
    }
   -Wire-([684,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([684,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([720,414],0,23445240,660)
    {
    Name = "alpD"
    Group = "Pulse Bridge"
    Display = "1"
    Scale = "57.3"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([756,666],0,23446000,590)
    {
    Name = "alpY"
    Group = "Pulse Bridge"
    Display = "1"
    Scale = "57.3"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.voltmetergnd([630,612],3,0,140)
    {
    Name = "Vdc6pY"
    }
   -Wire-([684,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([720,468],0,23145712,650)
    {
    Name = "Gamma D"
    Group = "Pulse Bridge"
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   0.pgb([756,720],0,23147856,580)
    {
    Name = "Gamma Y"
    Group = "Pulse Bridge"
    Display = "1"
    Scale = "57.2958"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "3.0"
    }
   -Wire-([684,702],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([756,846],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.compare([792,846],4,0,550)
    {
    X = "0.04"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.time-sig([864,846],2,0,200)
    {
    }
   0.gain([774,522],2,0,490)
    {
    G = "0.0174533"
    COM = "Gain"
    Dim = "1"
    }
   0.pgb([954,540],1,23030240,630)
    {
    Name = "Alpha Ord"
    Group = "Alpha Order"
    Display = "1"
    Scale = "1"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "180"
    }
   0.var_switch([990,648],5,23032168,150)
    {
    Name = "Fr"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.pi_ctlr([918,684],3,0,470)
    {
    GP = "2"
    TI = "0.01 [s]"
    YHI = "175"
    YLO = "90"
    YINIT = "145"
    Mthd = "0"
    INTR = "0"
    }
   0.sumjct([918,756],3,0,460)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([918,810],1,0,-1)
    {
    Name = "Idc"
    }
   -Wire-([918,810],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([954,756],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.var([972,828],3,23036416,190)
    {
    Name = "Idref"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "1.8"
    Units = ""
    Collect = "1"
    }
   -Wire-([972,792],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   .holder([918,612],3,0,480)
    {
    }
   -Wire-([576,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([576,738],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([684,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([918,522],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([918,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,432],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([720,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([756,684],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([756,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([810,522],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([288,576],0,0,-1)
    {
    Vertex="0,0;324,0;324,72"
    }
   -Wire-([630,378],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([630,378],0,0,-1)
    {
    Vertex="0,0;360,0"
    }
   -Wire-([954,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1008,450],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([954,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1008,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([954,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1008,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1026,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -ControlPanel-([576,72],0)
    {
    Name = "-ControlPanel-"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 576,72
    Extents = 0,0,216,126
    Meter(23983888)
    Meter(25247968)
    Meter(46216280)
    }
   -Sticky-([468,1350],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 468,1350,576,1404
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Control of MATLAB
 - 0 - disable
 - 1 - enable"
    }
   -ControlPanel-([486,1440],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = 468,1368
    Posn = 486,1440
    Extents = 0,0,72,126
    Switch(24001920)
    }
   0.var([882,270],0,23037216,80)
    {
    Name = "SCALE1"
    Group = "Matlab"
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.datalabel([954,270],4,0,-1)
    {
    Name = "SCALE1"
    }
   -Wire-([918,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([612,234],0,24752560,10)
    {
    Name = "VplusM"
    Group = "Matlab"
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.95"
    Units = ""
    Collect = "1"
    }
   0.datalabel([684,234],0,0,-1)
    {
    Name = "VplusM"
    }
   -Wire-([648,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([702,234],0,24753360,20)
    {
    Name = "VplusP"
    Group = "Matlab"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([774,234],0,0,-1)
    {
    Name = "VplusP"
    }
   -Wire-([738,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([792,234],0,24754160,30)
    {
    Name = "VminM"
    Group = "Matlab"
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([864,234],0,0,-1)
    {
    Name = "VminM"
    }
   -Wire-([828,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([612,270],0,24755144,50)
    {
    Name = "VzeroM"
    Group = "Matlab"
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([684,270],0,0,-1)
    {
    Name = "VzeroM"
    }
   -Wire-([648,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([702,270],0,24756376,60)
    {
    Name = "VzeroP"
    Group = "Matlab"
    Display = "0"
    Max = "180.0"
    Min = "-180.0"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([774,270],0,0,-1)
    {
    Name = "VzeroP"
    }
   -Wire-([738,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([792,270],0,24760352,70)
    {
    Name = "VminP"
    Group = "Matlab"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "0.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([864,270],0,0,-1)
    {
    Name = "VminP"
    }
   -Wire-([828,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([882,234],0,25387664,40)
    {
    Name = "Vbase"
    Group = "Matlab"
    Display = "0"
    Max = "1000.0"
    Min = "0.0"
    Value = "230.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([954,234],0,0,-1)
    {
    Name = "Vbase"
    }
   -Wire-([918,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([990,1062],3,0,280)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,1026],3,0,260)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([990,990],3,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([972,1098],0,0,-1)
    {
    Vertex="0,0;0,-90"
    }
   0.datalabel([972,1098],0,0,-1)
    {
    Name = "Iconv"
    }
   0.datalabel([1008,234],0,0,-1)
    {
    Name = "V1"
    }
   -Wire-([1008,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1044,234],0,25420184,700)
    {
    Name = "Bus Voltage"
    Group = "Bus Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   0.multimeter([396,612],0,0,120)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "Iconv"
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datalabel([1008,270],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1008,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.multimeter([1098,378],4,0,90)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "Idc"
    VolI = "Vdc12p"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Plot-([612,1296],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,594,270]
    Posn = [612,1296]
    Icon = [-1,-1]
    Extents = 0,0,594,270
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,594,207],"kA")
     {
     Options = 0
     Units = ""
     Curve(25309056,"Ia_y current ",0,,,)
     Curve(25311704,"Ia_d current",1,,,)
     Curve(46215208,"Idc",2,,,)
     }
    }
   0.unity([954,612],4,0,450)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([270,1530],4,0,500)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([720,792],4,0,560)
    {
    IType = "2"
    OType = "1"
    }
   0.voltmetergnd([540,774],3,0,170)
    {
    Name = "Vneut"
    }
   }
  }
 }

